/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component3;

import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.util.Maybe;
import com.technicalitiesmc.scm.api2.logical.StateLike;
import com.technicalitiesmc.scm.api3.component.CircuitComponent;
import com.technicalitiesmc.scm.api3.component.PlacementIntent;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SimpleCircuitComponent<S extends CircuitComponent.State<S>, P>
extends CircuitComponent<S, P> {
    private final CircuitComponent.Footprint footprint;
    private final VoxelShape shape;
    private final Maybe<StateLike<S>> defaultState;

    protected SimpleCircuitComponent(CircuitComponent.Footprint footprint, VoxelShape shape, StateLike<S> defaultState, CircuitComponent.StateLoader<S> stateLoader, Property<?> ... visualProperties) {
        super(stateLoader, visualProperties);
        this.footprint = footprint;
        this.shape = shape;
        this.defaultState = Maybe.value(defaultState);
    }

    @Override
    public Maybe<StateLike<S>> create(PlacementIntent<P> intent) {
        if (intent.footprint() != this.footprint) {
            return Maybe.error((String)"Unsupported footprint: %s", (Object[])new Object[]{intent.footprint()});
        }
        return this.defaultState;
    }

    @Override
    public VoxelShape getShape(ComponentState visualState) {
        return this.shape;
    }
}

